//LidScrewThreads.scad;

//This is version 2022_03_11;
//Previous versions used a separate, 
//trivial file: ScrewThread.scad to generate 
//the cylinder for the screw thread;
//That was confusing and for this version, 
//the cylinder is generated 
//within this module;

//The screw threads are generated as objects 
//to be used with difference() commands 
//to create clearance holes through which 
//the screw threads pass;

//The holes are normally created through 
//a floor resting on the XY plane;

//The calling module is responsible 
//for any other placement;

//For screw heads, 
//the hole depth is usually precise;
//For screw threads, it is often generous; 

include <BATT_Dimensions.scad>

module LidScrewThreads(HolePhi, HoleDepth)
{

//HolePhi = 3;
//HoleDepth = 6;

echo("Begin LidScrewThreads");
      
//DeltaZ is constant for all screws;
DeltaZ = HoleDepth/2 -2*Fuzz;

//Four screw thread objects;
//echo("BL = ", LidBLx, LidBLy);
translate([LidBLx, LidBLy, DeltaZ])
cylinder(h=HoleDepth,
    d=HolePhi, center=true, $fn=32);

//echo("BR = ", LidBRx, LidBRy);
translate([LidBRx, LidBRy, DeltaZ])
cylinder(h=HoleDepth,
    d=HolePhi, center=true, $fn=32);

//echo("TR = ", LidTRx, LidTRy);
translate([LidTRx, LidTRy, DeltaZ])
cylinder(h=HoleDepth,
    d=HolePhi, center=true, $fn=32);

//echo("TL = ", LidTLx, LidTLy);
translate([LidTLx, LidTLy, DeltaZ])
cylinder(h=HoleDepth,
    d=HolePhi, center=true, $fn=32);

}
//
